<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ResolvedNote extends Model 
{

    protected $table = 'resolved_notes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('note_id', 'user_id');

    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

    public function note()
    {
        return $this->belongsTo('App\Models\Notes');
    }

}